/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import com.google.common.collect.ArrayListMultimap;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DistillationTower;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_MegaDistillTower
extends GT_MetaTileEntity_DistillationTower {
    private static final int CASING_INDEX = 49;
    private short controllerY = 0;
    private final ArrayListMultimap<Integer, GT_MetaTileEntity_Hatch_Output> LAYERMAP = ArrayListMultimap.create();

    public GT_TileEntity_MegaDistillTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_MegaDistillTower(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaDistillTower(this.mName);
    }

    public String[] getDescription() {
        return new String[]{"Controller Block for the Mega Distillation Tower", "Size(WxHxD): 15xhx15 (Hollow), with h ranging from 16 to 61", "Controller (Front bottom)", "1+ Input Hatch (Any bottom layer casing)", "1+ Output Bus (Any bottom layer casing)", "An \"Output Layer\" consists of 5 layers!", "2-11+ Output Hatch (One or more per Output Layer)", "1x Maintenance Hatch (Any casing)", "1+ Energy Hatch (Any casing)", "Fluids are only put out at the correct height", "The correct height equals the slot number in the NEI recipe", "Clean Stainless Steel Machine Casings for the rest (15 x h - 5 at least!)", StatCollector.translateToLocal((String)"tooltip.bw.1.name") + "\u00a72" + " BartWorks"};
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        Block block;
        IGregTechTileEntity tileEntity;
        int z;
        int x;
        this.LAYERMAP.clear();
        this.controllerY = aBaseMetaTileEntity.getYCoord();
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 7;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 7;
        int y = 0;
        int casingAmount = 0;
        boolean reachedTop = false;
        for (x = xDir - 7; x <= xDir + 7; ++x) {
            for (z = zDir - 7; z <= zDir + 7; ++z) {
                if (x == 0 && z == 0) continue;
                tileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(x, y, z);
                block = aBaseMetaTileEntity.getBlockOffset(x, y, z);
                if (this.addInputToMachineList(tileEntity, 49) || this.addOutputToMachineList(tileEntity, 49) || this.addMaintenanceToMachineList(tileEntity, 49) || this.addEnergyInputToMachineList(tileEntity, 49)) continue;
                if (block != GregTech_API.sBlockCasings4 || aBaseMetaTileEntity.getMetaIDOffset(x, y, z) != 1) {
                    return false;
                }
                ++casingAmount;
            }
        }
        ++y;
        while (y <= 60 && !reachedTop) {
            for (x = -7; x <= 7; ++x) {
                for (z = -7; z <= 7; ++z) {
                    boolean middle;
                    tileEntity = aBaseMetaTileEntity.getIGregTechTileEntity(aBaseMetaTileEntity.getXCoord() + xDir + x, aBaseMetaTileEntity.getYCoord() + y, aBaseMetaTileEntity.getZCoord() + zDir + z);
                    block = aBaseMetaTileEntity.getBlock(aBaseMetaTileEntity.getXCoord() + xDir + x, aBaseMetaTileEntity.getYCoord() + y, aBaseMetaTileEntity.getZCoord() + zDir + z);
                    boolean bl = middle = Math.abs(x) < 7 && Math.abs(z) != 7;
                    if (aBaseMetaTileEntity.getAir(aBaseMetaTileEntity.getXCoord() + xDir + x, aBaseMetaTileEntity.getYCoord() + y, aBaseMetaTileEntity.getZCoord() + zDir + z)) {
                        if (middle) continue;
                        return false;
                    }
                    if (middle) {
                        reachedTop = true;
                    }
                    if (this.addOutputToMachineList(tileEntity, 49) || this.addMaintenanceToMachineList(tileEntity, 49) || this.addEnergyInputToMachineList(tileEntity, 49)) continue;
                    if (block != GregTech_API.sBlockCasings4 || aBaseMetaTileEntity.getMetaID(aBaseMetaTileEntity.getXCoord() + xDir + x, aBaseMetaTileEntity.getYCoord() + y, aBaseMetaTileEntity.getZCoord() + zDir + z) != 1) {
                        return false;
                    }
                    ++casingAmount;
                }
            }
            ++y;
        }
        return casingAmount >= 15 * y - 5 && y >= 16 && y <= 61 && reachedTop;
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (super.addOutputToMachineList(aTileEntity, aBaseCasingIndex)) {
            if (aTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_Output) {
                int layer = aTileEntity.getYCoord() - this.controllerY;
                layer = (int)MathUtils.ceil((double)layer / 5.0) - 1;
                this.LAYERMAP.put((Object)layer, (Object)((GT_MetaTileEntity_Hatch_Output)aTileEntity.getMetaTileEntity()));
            }
            return true;
        }
        return false;
    }

    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (int i = 0; i < mOutputFluids2.length; ++i) {
            for (int j = 0; j < this.LAYERMAP.get((Object)i).size(); ++j) {
                ((GT_MetaTileEntity_Hatch_Output)this.LAYERMAP.get((Object)i).get(j)).fill(new FluidStack(mOutputFluids2[i], mOutputFluids2[i].amount / this.LAYERMAP.get((Object)i).size()), true);
            }
        }
    }

    public boolean checkRecipe(ItemStack aStack) {
        ArrayList tFluidList = this.getStoredFluids();
        block0: for (int i = 0; i < tFluidList.size() - 1; ++i) {
            for (int j = i + 1; j < tFluidList.size(); ++j) {
                if (!GT_Utility.areFluidsEqual((FluidStack)((FluidStack)tFluidList.get(i)), (FluidStack)((FluidStack)tFluidList.get(j)))) continue;
                if (((FluidStack)tFluidList.get((int)i)).amount < ((FluidStack)tFluidList.get((int)j)).amount) {
                    tFluidList.remove(i--);
                    continue block0;
                }
                tFluidList.remove(j--);
            }
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(0, GT_Utility.getTier((long)tVoltage));
        long nominalV = BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
        if (tFluids.length > 0) {
            for (FluidStack tFluid : tFluids) {
                int processed;
                ArrayList<FluidStack[]> outputFluids = new ArrayList<FluidStack[]>();
                boolean found_Recipe = false;
                GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sDistillationRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], new FluidStack[]{tFluid}, new ItemStack[0]);
                for (processed = 0; this.getStoredFluids().size() > 0 && processed < ConfigHandler.megaMachinesMax && tRecipe != null && (long)(tRecipe.mEUt * (processed + 1)) < nominalV && tRecipe.isRecipeInputEqual(true, tFluids, new ItemStack[0]); ++processed) {
                    found_Recipe = true;
                    if (tRecipe.mFluidOutputs.length == 1 && tRecipe.mFluidOutputs[0].amount == 0) {
                        tRecipe.mFluidOutputs[0].amount = tRecipe.mFluidInputs[0].amount;
                    }
                    FluidStack[] output = new FluidStack[tRecipe.mFluidOutputs.length];
                    for (int i = 0; i < output.length; ++i) {
                        output[i] = new FluidStack(tRecipe.mFluidOutputs[i], tRecipe.mFluidOutputs[i].amount);
                    }
                    outputFluids.add(output);
                }
                if (!found_Recipe) continue;
                for (int j = 1; j < outputFluids.size(); ++j) {
                    for (int k = 0; k < ((FluidStack[])outputFluids.get(j)).length; ++k) {
                        ((FluidStack[])outputFluids.get((int)0))[k].amount += ((FluidStack[])outputFluids.get((int)j))[k].amount;
                    }
                }
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                long actualEUT = (long)tRecipe.mEUt * (long)processed;
                if (actualEUT > Integer.MAX_VALUE) {
                    int divider = 0;
                    while (actualEUT > Integer.MAX_VALUE) {
                        actualEUT /= 2L;
                        divider = (byte)(divider + 1);
                    }
                    BW_Util.calculateOverclockedNessMulti((int)(actualEUT / (long)(divider * 2)), tRecipe.mDuration * (divider * 2), 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
                } else {
                    BW_Util.calculateOverclockedNessMulti((int)actualEUT, tRecipe.mDuration, 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
                }
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputFluids = (FluidStack[])((FluidStack[])outputFluids.get(0)).clone();
                if (tRecipe.getOutput(0) != null) {
                    int stacks = processed / 64;
                    ItemStack[] outputs = new ItemStack[stacks];
                    if (stacks > 0) {
                        for (int i = 0; i < stacks; ++i) {
                            outputs[i] = i != stacks - 1 ? tRecipe.getOutput(0).splitStack(64) : tRecipe.getOutput(0).splitStack(processed - 64 * i);
                        }
                        this.mOutputItems = outputs;
                    } else {
                        this.mOutputItems = null;
                    }
                } else {
                    this.mOutputItems = null;
                }
                this.updateSlots();
                return true;
            }
        }
        return false;
    }
}

